import { createPlaywrightRouter, Dataset } from '@crawlee/playwright';
export const router = createPlaywrightRouter();
router.addDefaultHandler(async ({ enqueueLinks, log }) => {
    log.info(`enqueueing new URLs`);
    await enqueueLinks({
        globs: ['https://apify.com/*'],
        label: 'detail',
    });
});
router.addHandler('detail', async ({ request, page, log }) => {
    const title = await page.title();
    log.info(`${title}`, { url: request.loadedUrl });
    await Dataset.pushData({
        url: request.loadedUrl,
        title,
    });
});
//# sourceMappingURL=routes.js.map